{* cPanel Extended - Server Module Client Area (Part 9) *}
<link rel="stylesheet" href="{$WEB_ROOT}/modules/servers/cp_extended/assets/client.css?v=0.2">

<div id="cp-extended" class="cpx">
  <div class="cpx__wrap">
    <div class="cpx__hero">
      <div>
        <h2 class="cpx__h2">cPanel Extended</h2>
        <div class="cpx__sub">Service #{$serviceId} • {$domain|escape}</div>
      </div>
      <div class="cpx__pill">Extended Panel</div>
    </div>

    {if !$enabled}
      <div class="cpx__alert">
        Extended panel is <b>disabled</b> for this product. Enable it in:
        <b>Addon → Products → Configure → “Enable Extended Panel”</b>.
      </div>
    {else}
      <div class="cpx__toolbar">
        <a class="cpx__btn" href="{$baseLink}&cpxt_sso=cpanel">Login to cPanel</a>
        <a class="cpx__btn cpx__btn--ghost" href="{$baseLink}&cpxt_sso=webmail">Webmail</a>
        <a class="cpx__btn cpx__btn--ghost" href="{$baseLink}&cpxt_sso=phpmyadmin">phpMyAdmin</a>
        <a class="cpx__btn cpx__btn--ghost" href="{$baseLink}&cpxt_sso=filemanager">File Manager</a>
      </div>

      {if $flash}
        <div class="cpx__notice {if $flashType=='error'}is-error{/if}">{$flash|escape}</div>
      {/if}

      <div class="cpx__grid">
        <div class="cpx__card cpx__card--pad">
          <div class="cpx__card-h">Navigation</div>
          <div class="cpx__muted">Enabled features for this product.</div>

          <div class="cpx__nav">
            <a class="cpx__navitem {if $page=='home'}is-active{/if}" href="{$baseLink}&cpxt_page=home">Home</a>

            
            {if in_array('ftp_accounts',$features)}
              <a class="cpx__navitem {if $page=='ftp'}is-active{/if}" href="{$baseLink}&cpxt_page=ftp">FTP Accounts</a>
            {/if}

            {if in_array('cron_jobs',$features)}
              <a class="cpx__navitem {if $page=='cron'}is-active{/if}" href="{$baseLink}&cpxt_page=cron">Cron Jobs</a>
            {/if}

            {if in_array('mysql_databases',$features)}
              <a class="cpx__navitem {if $page=='mysql'}is-active{/if}" href="{$baseLink}&cpxt_page=mysql">MySQL Databases</a>
            {/if}

            {if in_array('ssl_tls',$features)}
              <a class="cpx__navitem {if $page=='ssl'}is-active{/if}" href="{$baseLink}&cpxt_page=ssl">SSL/TLS</a>
            {/if}

            {if in_array('backups',$features)}
              <a class="cpx__navitem {if $page=='backups'}is-active{/if}" href="{$baseLink}&cpxt_page=backups">Backups</a>
            {/if}

            {if in_array('email_accounts',$features)}
              <a class="cpx__navitem {if $page=='email'}is-active{/if}" href="{$baseLink}&cpxt_page=email">Email Accounts</a>
            {/if}

            {if $features|@count == 0}
              <div class="cpx__muted" style="margin-top:10px;">No features enabled yet.</div>
            {/if}
          </div>

          <div class="cpx__hr"></div>
          <div class="cpx__muted" style="font-size:12px;">
            cPanel User: <b>{$cpUser|escape}</b>
          </div>
        </div>

        <div class="cpx__card cpx__card--pad">
          {if $page=='home'}
            <div class="cpx__card-h">Welcome</div>
            <div class="cpx__muted">
              This is Part 9: we added real SSO links and the first feature page (Email Accounts list).
              Next parts will add create/delete actions and more feature modules.
            </div>
            <div style="margin-top:12px;">
              <span class="cpx__badge">Template: {$template|escape}</span>
              <span class="cpx__badge">Installer: {$installer|escape}</span>
            </div>

          {elseif $page=='email'}
            <div class="cpx__card-h">Email Accounts</div>

            {if $emailError}
              <div class="cpx__alert">{$emailError|escape}</div>
            {/if}

            <div class="cpx__split">
              <div class="cpx__panel">
                <div class="cpx__panel-h">Create Email</div>
                <form method="post" action="{$baseLink}&cpxt_page=email">
                  <input type="hidden" name="cpxt_action" value="email_create">
                  <div class="cpx__row">
                    <input class="cpx__input" type="text" name="local" placeholder="local-part" required>
                    <span class="cpx__at">@</span>
                    <input class="cpx__input" type="text" name="email_domain" placeholder="domain.com" value="{$domain|escape}">
                  </div>
                  <div class="cpx__row">
                    <input class="cpx__input" type="password" name="password" placeholder="Password" required>
                    <input class="cpx__input" type="number" min="0" name="quota" placeholder="Quota (MB) e.g. 1024">
                  </div>
                  <button class="cpx__btn" type="submit">Queue Create</button>
                </form>
                <div class="cpx__hint">Runs via queue worker for safety.</div>
              </div>

              <div class="cpx__panel">
                <div class="cpx__panel-h">Bulk Delete</div>
                <form method="post" action="{$baseLink}&cpxt_page=email" onsubmit="return confirm('Delete selected email accounts?');">
                  <input type="hidden" name="cpxt_action" value="email_bulk_delete">

                  <div class="cpx__tablewrap" style="max-height:220px;">
                    <table class="cpx__table">
                      <thead>
                        <tr>
                          <th style="width:40px;"></th>
                          <th>Email</th>
                          <th>Used</th>
                        </tr>
                      </thead>
                      <tbody>
                        {if $emailAccounts|@count == 0}
                          <tr><td colspan="3" class="cpx__muted">No email accounts to select.</td></tr>
                        {else}
                          {foreach $emailAccounts as $a}
                            {assign var=addr value=$a.email|default:$a.user}
                            <tr>
                              <td><input type="checkbox" name="emails[]" value="{$addr|escape}"></td>
                              <td><b>{$addr|escape}</b></td>
                              <td class="cpx__muted">{$a.diskused|default:$a.disk_used|default:'-'|escape}</td>
                            </tr>
                          {/foreach}
                        {/if}
                      </tbody>
                    </table>
                  </div>

                  <button class="cpx__btn cpx__btn--danger" type="submit">Queue Delete Selected</button>
                </form>
              </div>
            </div>

            <div class="cpx__hr"></div>

            <div class="cpx__panel">
              <div class="cpx__panel-h">Manage Single Account</div>
              <div class="cpx__grid2">
                <form method="post" action="{$baseLink}&cpxt_page=email" class="cpx__form">
                  <input type="hidden" name="cpxt_action" value="email_passwd">
                  <div class="cpx__label">Change Password</div>
                  <input class="cpx__input" type="text" name="email" placeholder="email@domain.com" required>
                  <input class="cpx__input" type="password" name="password" placeholder="New password" required>
                  <button class="cpx__btn" type="submit">Queue Password</button>
                </form>

                <form method="post" action="{$baseLink}&cpxt_page=email" class="cpx__form">
                  <input type="hidden" name="cpxt_action" value="email_quota">
                  <div class="cpx__label">Change Quota (MB)</div>
                  <input class="cpx__input" type="text" name="email" placeholder="email@domain.com" required>
                  <input class="cpx__input" type="number" min="0" name="quota" placeholder="0 = unlimited">
                  <button class="cpx__btn" type="submit">Queue Quota</button>
                </form>

                <form method="post" action="{$baseLink}&cpxt_page=email" class="cpx__form" onsubmit="return confirm('Delete this email account?');">
                  <input type="hidden" name="cpxt_action" value="email_delete">
                  <div class="cpx__label">Delete Email</div>
                  <input class="cpx__input" type="text" name="email" placeholder="email@domain.com" required>
                  <button class="cpx__btn cpx__btn--danger" type="submit">Queue Delete</button>
                </form>
              </div>
              <div class="cpx__hint">All actions are queued. Run the queue worker cron to execute.</div>
            </div>

            <div class="cpx__hr"></div>

            <div class="cpx__panel">
              <div class="cpx__panel-h">Email Accounts (Current)</div>
              <div class="cpx__tablewrap">
                <table class="cpx__table">
                  <thead>
                    <tr>
                      <th>Email</th>
                      <th>Quota</th>
                      <th>Used</th>
                    </tr>
                  </thead>
                  <tbody>
                    {if $emailAccounts|@count == 0}
                      <tr><td colspan="3" class="cpx__muted">No email accounts found (or API blocked).</td></tr>
                    {else}
                      {foreach $emailAccounts as $a}
                        <tr>
                          <td><b>{$a.email|default:$a.user|escape}</b></td>
                          <td class="cpx__muted">{$a.quota|default:'-'|escape}</td>
                          <td class="cpx__muted">{$a.diskused|default:$a.disk_used|default:'-'|escape}</td>
                        </tr>
                      {/foreach}
                    {/if}
                  </tbody>
                </table>
              </div>
            </div>


          {else}
                    {foreach $emailAccounts as $a}
                      <tr>
                        <td><b>{$a.email|default:$a.user|escape}</b></td>
                        <td class="cpx__muted">{$a.quota|default:'-'|escape}</td>
                        <td class="cpx__muted">{$a.diskused|default:$a.disk_used|default:'-'|escape}</td>
                      </tr>
                    {/foreach}
                  {/if}
                </tbody>
              </table>
            </div>

          {elseif $page=='ftp'}
            <div class="cpx__card-h">FTP Accounts</div>

            {if $ftpError}
              <div class="cpx__alert">{$ftpError|escape}</div>
            {/if}

            <div class="cpx__split">
              <div class="cpx__panel">
                <div class="cpx__panel-h">Create FTP Account</div>
                <form method="post" action="{$baseLink}&cpxt_page=ftp">
                  <input type="hidden" name="cpxt_action" value="ftp_create">
                  <div class="cpx__row">
                    <input class="cpx__input" type="text" name="user" placeholder="ftpuser" required>
                    <input class="cpx__input" type="password" name="password" placeholder="Password" required>
                  </div>
                  <div class="cpx__row">
                    <input class="cpx__input" type="text" name="homedir" placeholder="/public_html/dir (optional)">
                    <input class="cpx__input" type="number" min="0" name="quota" placeholder="Quota (MB) 0 = unlimited">
                  </div>
                  <button class="cpx__btn" type="submit">Queue Create</button>
                </form>
              </div>

              <div class="cpx__panel">
                <div class="cpx__panel-h">Delete FTP Account</div>
                <form method="post" action="{$baseLink}&cpxt_page=ftp" onsubmit="return confirm('Delete this FTP account?');">
                  <input type="hidden" name="cpxt_action" value="ftp_delete">
                  <div class="cpx__row">
                    <input class="cpx__input" type="text" name="user" placeholder="ftpuser" required>
                    <label class="cpx__muted" style="display:flex;align-items:center;gap:8px;">
                      <input type="checkbox" name="destroy" value="1"> Delete files
                    </label>
                  </div>
                  <button class="cpx__btn cpx__btn--danger" type="submit">Queue Delete</button>
                </form>
              </div>
            </div>

            <div class="cpx__hr"></div>

            <div class="cpx__panel">
              <div class="cpx__panel-h">Change FTP Password</div>
              <form method="post" action="{$baseLink}&cpxt_page=ftp">
                <input type="hidden" name="cpxt_action" value="ftp_passwd">
                <div class="cpx__row">
                  <input class="cpx__input" type="text" name="user" placeholder="ftpuser" required>
                  <input class="cpx__input" type="password" name="password" placeholder="New password" required>
                </div>
                <button class="cpx__btn" type="submit">Queue Password</button>
              </form>
            </div>

            <div class="cpx__hr"></div>

            <div class="cpx__panel">
              <div class="cpx__panel-h">FTP Accounts (Current)</div>
              <div class="cpx__tablewrap">
                <table class="cpx__table">
                  <thead>
                    <tr>
                      <th>User</th>
                      <th>Dir</th>
                      <th>Quota</th>
                    </tr>
                  </thead>
                  <tbody>
                    {if $ftpAccounts|@count == 0}
                      <tr><td colspan="3" class="cpx__muted">No FTP accounts found (or API blocked).</td></tr>
                    {else}
                      {foreach $ftpAccounts as $a}
                        <tr>
                          <td><b>{$a.user|default:$a.login|escape}</b></td>
                          <td class="cpx__muted">{$a.dir|default:$a.homedir|default:'-'|escape}</td>
                          <td class="cpx__muted">{$a.quota|default:'-'|escape}</td>
                        </tr>
                      {/foreach}
                    {/if}
                  </tbody>
                </table>
              </div>
            </div>

          {elseif $page=='cron'}
            <div class="cpx__card-h">Cron Jobs</div>

            {if $cronError}
              <div class="cpx__alert">{$cronError|escape}</div>
            {/if}

            <div class="cpx__split">
              <div class="cpx__panel">
                <div class="cpx__panel-h">Add Cron (raw line)</div>
                <form method="post" action="{$baseLink}&cpxt_page=cron">
                  <input type="hidden" name="cpxt_action" value="cron_add">
                  <input class="cpx__input" type="text" name="line" placeholder="* * * * * /usr/bin/php /home/user/script.php" required>
                  <button class="cpx__btn" type="submit" style="margin-top:10px;">Queue Add</button>
                </form>
                <div class="cpx__hint">We use raw cron line for now (fast + compatible).</div>
              </div>

              <div class="cpx__panel">
                <div class="cpx__panel-h">Delete Cron</div>
                <form method="post" action="{$baseLink}&cpxt_page=cron" onsubmit="return confirm('Delete this cron job?');">
                  <input type="hidden" name="cpxt_action" value="cron_delete">
                  <input class="cpx__input" type="text" name="linekey" placeholder="linekey (from list)" required>
                  <button class="cpx__btn cpx__btn--danger" type="submit" style="margin-top:10px;">Queue Delete</button>
                </form>
              </div>
            </div>

            <div class="cpx__hr"></div>

            <div class="cpx__panel">
              <div class="cpx__panel-h">Cron Jobs (Current)</div>
              <div class="cpx__tablewrap">
                <table class="cpx__table">
                  <thead>
                    <tr>
                      <th>Line</th>
                      <th>LineKey</th>
                    </tr>
                  </thead>
                  <tbody>
                    {if $cronItems|@count == 0}
                      <tr><td colspan="2" class="cpx__muted">No cron jobs found (or API blocked).</td></tr>
                    {else}
                      {foreach $cronItems as $c}
                        <tr>
                          <td><b>{$c.command|default:$c.line|escape}</b></td>
                          <td class="cpx__muted">{$c.linekey|default:$c.key|default:'-'|escape}</td>
                        </tr>
                      {/foreach}
                    {/if}
                  </tbody>
                </table>
              </div>
              <div class="cpx__hint">If your server returns a different shape, we’ll normalize it in a later refinement.</div>
            </div>

          {elseif $page=='mysql'}
            <div class="cpx__card-h">MySQL Databases</div>

            {if $mysqlError}
              <div class="cpx__alert">{$mysqlError|escape}</div>
            {/if}

            <div class="cpx__split">
              <div class="cpx__panel">
                <div class="cpx__panel-h">Create / Delete Database</div>

                <form method="post" action="{$baseLink}&cpxt_page=mysql" style="margin-bottom:10px;">
                  <input type="hidden" name="cpxt_action" value="mysql_db_create">
                  <div class="cpx__row">
                    <input class="cpx__input" type="text" name="db" placeholder="dbname" required>
                    <button class="cpx__btn" type="submit">Queue Create</button>
                  </div>
                </form>

                <form method="post" action="{$baseLink}&cpxt_page=mysql" onsubmit="return confirm('Delete this database?');">
                  <input type="hidden" name="cpxt_action" value="mysql_db_delete">
                  <div class="cpx__row">
                    <input class="cpx__input" type="text" name="db" placeholder="dbname" required>
                    <button class="cpx__btn cpx__btn--danger" type="submit">Queue Delete</button>
                  </div>
                </form>

                <div class="cpx__hint">Note: Some systems auto-prefix db names (e.g. user_dbname).</div>
              </div>

              <div class="cpx__panel">
                <div class="cpx__panel-h">Create / Delete User</div>

                <form method="post" action="{$baseLink}&cpxt_page=mysql" style="margin-bottom:10px;">
                  <input type="hidden" name="cpxt_action" value="mysql_user_create">
                  <div class="cpx__row">
                    <input class="cpx__input" type="text" name="user" placeholder="dbuser" required>
                    <input class="cpx__input" type="password" name="password" placeholder="Password" required>
                  </div>
                  <button class="cpx__btn" type="submit">Queue Create</button>
                </form>

                <form method="post" action="{$baseLink}&cpxt_page=mysql" onsubmit="return confirm('Delete this DB user?');">
                  <input type="hidden" name="cpxt_action" value="mysql_user_delete">
                  <div class="cpx__row">
                    <input class="cpx__input" type="text" name="user" placeholder="dbuser" required>
                    <button class="cpx__btn cpx__btn--danger" type="submit">Queue Delete</button>
                  </div>
                </form>

                <div class="cpx__hint">Privileges/assignments will be added in a refinement.</div>
              </div>
            </div>

            <div class="cpx__hr"></div>

            <div class="cpx__split">
              <div class="cpx__panel">
                <div class="cpx__panel-h">Databases (Current)</div>
                <div class="cpx__tablewrap" style="max-height:240px;">
                  <table class="cpx__table">
                    <thead><tr><th>Database</th></tr></thead>
                    <tbody>
                      {if $mysqlDbs|@count == 0}
                        <tr><td class="cpx__muted">No databases found.</td></tr>
                      {else}
                        {foreach $mysqlDbs as $d}
                          <tr><td><b>{$d.db|default:$d.database|default:$d|escape}</b></td></tr>
                        {/foreach}
                      {/if}
                    </tbody>
                  </table>
                </div>
              </div>

              <div class="cpx__panel">
                <div class="cpx__panel-h">Users (Current)</div>
                <div class="cpx__tablewrap" style="max-height:240px;">
                  <table class="cpx__table">
                    <thead><tr><th>User</th></tr></thead>
                    <tbody>
                      {if $mysqlUsers|@count == 0}
                        <tr><td class="cpx__muted">No users found.</td></tr>
                      {else}
                        {foreach $mysqlUsers as $u}
                          <tr><td><b>{$u.user|default:$u.name|default:$u|escape}</b></td></tr>
                        {/foreach}
                      {/if}
                    </tbody>
                  </table>
                </div>
              </div>
            </div>

          {elseif $page=='ssl'}
            <div class="cpx__card-h">SSL/TLS</div>
            <div class="cpx__muted">
              This UI shell is included. SSL actions (AutoSSL, install cert, CSR, etc.) are wired in a later refinement.
            </div>

          {elseif $page=='backups'}
            <div class="cpx__card-h">Backups</div>
            <div class="cpx__muted">
              This UI shell is included. Backup/restore integrations (JetBackup/cPanel backups) are wired in a later refinement.
            </div>

{else}
            <div class="cpx__card-h">Not Found</div>
            <div class="cpx__muted">This page is not available.</div>
          {/if}
        </div>
      </div>

      <div style="height:12px;"></div>
      <div class="cpx__card cpx__card--pad">
        <div class="cpx__card-h">Recent Tasks</div>
        <div class="cpx__muted">Latest 10 queue tasks for this service.</div>
        <div class="cpx__tablewrap">
          <table class="cpx__table" style="min-width:520px;">
            <thead>
              <tr>
                <th>ID</th>
                <th>Type</th>
                <th>Status</th>
                <th>Updated</th>
              </tr>
            </thead>
            <tbody>
              {if $tasks|@count == 0}
                <tr><td colspan="4" class="cpx__muted">No tasks yet.</td></tr>
              {else}
                {foreach $tasks as $t}
                  <tr>
                    <td>{$t.id}</td>
                    <td><b>{$t.type|escape}</b></td>
                    <td><span class="cpx__badge">{$t.status|escape}</span></td>
                    <td class="cpx__muted">{$t.updated_at|escape}</td>
                  </tr>
                {/foreach}
              {/if}
            </tbody>
          </table>
        </div>
      </div>
    {/if}
  </div>
</div>
