<?php
namespace CpExtended;

class Utils
{
    public static function boolvalStrict($v): bool
    {
        if (is_bool($v)) return $v;
        $s = strtolower(trim((string)$v));
        return in_array($s, ['1','true','yes','on'], true);
    }

    public static function safePage(string $p): string
    {
        $p = preg_replace('/[^a-z0-9_\-]/i','', $p);
        return $p ?: 'home';
    }
}
