<?php
namespace CpExtended;

use WHMCS\Database\Capsule;

/**
 * Reads product settings stored by the addon module in mod_cp_ext_settings table.
 */
class Settings
{
    public static function forProduct(int $productId): array
    {
        $scope = 'product:' . $productId;

        $enabled = self::getSetting('enabled', $scope, '0') === '1';
        $template = self::getSetting('template', $scope, 'default');
        $installer = self::getSetting('installer', $scope, 'none');

        $featuresJson = self::getSetting('features_json', $scope, '[]');
        $features = json_decode((string)$featuresJson, true);
        if (!is_array($features)) $features = [];

        return [
            'enabled' => $enabled,
            'template' => $template,
            'installer' => $installer,
            'features' => $features,
        ];
    }

    private static function getSetting(string $key, string $scope, string $default = '')
    {
        try {
            if (!Capsule::schema()->hasTable('mod_cp_ext_settings')) return $default;

            $row = Capsule::table('mod_cp_ext_settings')
                ->where('scope', $scope)
                ->where('key', $key)
                ->first();

            if (!$row) return $default;
            return (string)$row->value;
        } catch (\Throwable $e) {
            return $default;
        }
    }
}
