<?php
namespace CpExtended;

use WHMCS\Database\Capsule;

class Queue
{
    public static function enqueue(string $type, array $payload, int $userId, int $serviceId): int
    {
        if (!Capsule::schema()->hasTable('mod_cp_ext_queue')) {
            throw new \Exception('Queue table missing. Activate addon module first.');
        }
        return (int)Capsule::table('mod_cp_ext_queue')->insertGetId([
            'type' => $type,
            'status' => 'pending',
            'related_user_id' => $userId,
            'related_service_id' => $serviceId,
            'attempts' => 0,
            'available_at' => null,
            'payload_json' => json_encode($payload, JSON_UNESCAPED_SLASHES),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
    }

    public static function latestForService(int $serviceId, int $limit = 10): array
    {
        try {
            if (!Capsule::schema()->hasTable('mod_cp_ext_queue')) return [];
            $rows = Capsule::table('mod_cp_ext_queue')
                ->where('related_service_id', $serviceId)
                ->orderBy('id','desc')
                ->limit($limit)
                ->get();
            return json_decode(json_encode($rows), true) ?: [];
        } catch (\Throwable $e) {
            return [];
        }
    }
}
