{* cPanel Extended - Client Hub (Addon Module Part 7) *}

<link rel="stylesheet" href="{$WEB_ROOT}/modules/addons/cp_extended_admin/assets/client.css?v=1.0.6">

<div id="cp-ext-client" class="cpxt">
  <div class="cpxt__wrap">
    <div class="cpxt__hero">
      <div>
        <h1 class="cpxt__h1">{$strings.title|escape}</h1>
        <p class="cpxt__sub">{$strings.subtitle|escape}</p>
      </div>
      <div class="cpxt__pill">Client Area</div>
    </div>

    <div class="cpxt__alert">{$strings.note|escape}</div>

    <div class="cpxt__card">
      <div class="cpxt__card-h">Your Hosting Services</div>

      {if $services|@count == 0}
        <div class="cpxt__empty">{$strings.no_services|escape}</div>
      {else}
        <div class="cpxt__tablewrap">
          <table class="cpxt__table">
            <thead>
              <tr>
                <th>{$strings.service|escape}</th>
                <th>Status</th>
                <th>Extended</th>
                <th></th>
              </tr>
            </thead>
            <tbody>
              {foreach $services as $s}
                <tr>
                  <td>
                    <div class="cpxt__svc">
                      <div class="cpxt__svc-title">{$s.productname|escape}</div>
                      <div class="cpxt__svc-sub">{$s.domain|escape} • ID: {$s.serviceid}</div>
                    </div>
                  </td>
                  <td><span class="cpxt__badge">{$s.status|escape}</span></td>
                  <td>
                    {if $s.extended_enabled}
                      <span class="cpxt__badge cpxt__badge--on">On</span>
                    {else}
                      <span class="cpxt__badge">{$strings.disabled|escape}</span>
                    {/if}
                  </td>
                  <td class="cpxt__right">
                    <a class="cpxt__btn" href="clientarea.php?action=productdetails&id={$s.serviceid}">{$strings.open|escape}</a>
                  </td>
                </tr>
              {/foreach}
            </tbody>
          </table>
        </div>
      {/if}
    </div>

    <div class="cpxt__grid">
      <div class="cpxt__card cpxt__card--pad">
        <div class="cpxt__card-h">Quick Shortcuts</div>
        <div class="cpxt__muted">These buttons will become active once the Server Module is installed.</div>
        <div class="cpxt__actions">
          <button class="cpxt__btn cpxt__btn--ghost" disabled>cPanel Login</button>
          <button class="cpxt__btn cpxt__btn--ghost" disabled>Webmail</button>
          <button class="cpxt__btn cpxt__btn--ghost" disabled>phpMyAdmin</button>
          <button class="cpxt__btn cpxt__btn--ghost" disabled>File Manager</button>
        </div>
      </div>

      <div class="cpxt__card cpxt__card--pad">
        <div class="cpxt__card-h">Enabled Features (Preview)</div>
        <div class="cpxt__muted">Preview of feature toggles from the product config.</div>
        <ul class="cpxt__list">
          {foreach $services as $s}
            {if $s.extended_enabled}
              <li class="cpxt__li">
                <div class="cpxt__li-title">{$s.productname|escape}</div>
                <div class="cpxt__tags">
                  {foreach $s.features as $f}
                    <span class="cpxt__tag">{$f|escape}</span>
                  {/foreach}
                </div>
              </li>
            {/if}
          {/foreach}
        </ul>
      </div>
    </div>
  </div>
</div>
