<?php
use WHMCS\Database\Capsule;

$baseUrl = $data['baseUrl'] ?? 'addonmodules.php?module=cp_extended_admin';
$token = htmlspecialchars($data['token'] ?? '');

$lang = isset($_GET['lang']) ? preg_replace('/[^a-z0-9_\-]/i','', (string)$_GET['lang']) : 'english';
if ($lang === '') $lang = 'english';

$scope = isset($_GET['scope']) ? preg_replace('/[^a-z0-9:\_\-]/i','', (string)$_GET['scope']) : 'global';
if ($scope === '') $scope = 'global';

$q = isset($_GET['q']) ? trim((string)$_GET['q']) : '';

$query = Capsule::table('mod_cp_ext_translations')
    ->where('lang', $lang)
    ->where('scope', $scope);

if ($q !== '') {
    $query->where(function($w) use ($q) {
        $w->where('key','like','%'.$q.'%')->orWhere('value','like','%'.$q.'%');
    });
}

$items = $query->orderBy('key','asc')->limit(200)->get();

// list product scopes quick
$products = Capsule::table('tblproducts')->select('id','name')->orderBy('name','asc')->get();
?>
<div class="cp-ext__header">
  <div>
    <h1 class="cp-ext__h1">Translations</h1>
    <p class="cp-ext__muted">Override module language strings globally or per product. (Used later in client-area templates.)</p>
  </div>
</div>

<div class="cp-ext__card cp-ext__card--pad" style="margin-bottom:14px;">
  <form method="get" action="<?php echo $baseUrl; ?>">
    <input type="hidden" name="module" value="cp_extended_admin">
    <input type="hidden" name="page" value="translations">

    <div class="cp-ext__grid" style="grid-template-columns: repeat(4, minmax(0,1fr));">
      <div class="cp-ext__form-row">
        <label class="cp-ext__label">Language</label>
        <input class="cp-ext__input" type="text" name="lang" value="<?php echo htmlspecialchars($lang); ?>" placeholder="english">
      </div>

      <div class="cp-ext__form-row">
        <label class="cp-ext__label">Scope</label>
        <select class="cp-ext__input" name="scope">
          <option value="global" <?php echo $scope==='global'?'selected':''; ?>>Global</option>
          <?php foreach ($products as $p): $val='product:'.$p->id; ?>
            <option value="<?php echo $val; ?>" <?php echo $scope===$val?'selected':''; ?>>
              <?php echo htmlspecialchars($p->name); ?> (<?php echo $val; ?>)
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="cp-ext__form-row" style="grid-column: span 2;">
        <label class="cp-ext__label">Search</label>
        <input class="cp-ext__input" type="text" name="q" value="<?php echo htmlspecialchars($q); ?>" placeholder="key or value contains...">
      </div>
    </div>

    <div class="cp-ext__actions">
      <button class="cp-ext__btn-primary" type="submit">Filter</button>
      <a class="cp-ext__btn" href="<?php echo $baseUrl; ?>&page=translations">Reset</a>
    </div>
  </form>
</div>

<div class="cp-ext__card cp-ext__card--pad" style="margin-bottom:14px;">
  <div class="cp-ext__card-title" style="padding:0 0 10px 0;">Add / Update Translation</div>

  <form method="post" action="<?php echo $baseUrl; ?>&page=translations">
    <input type="hidden" name="token" value="<?php echo $token; ?>">
    <input type="hidden" name="action" value="translation_save">

    <div class="cp-ext__grid" style="grid-template-columns: repeat(4, minmax(0,1fr));">
      <div class="cp-ext__form-row">
        <label class="cp-ext__label">Language</label>
        <input class="cp-ext__input" type="text" name="lang" value="<?php echo htmlspecialchars($lang); ?>">
      </div>

      <div class="cp-ext__form-row">
        <label class="cp-ext__label">Scope</label>
        <input class="cp-ext__input" type="text" name="scope" value="<?php echo htmlspecialchars($scope); ?>">
        <div class="cp-ext__hint">Example: global or product:12</div>
      </div>

      <div class="cp-ext__form-row" style="grid-column: span 2;">
        <label class="cp-ext__label">Key</label>
        <input class="cp-ext__input" type="text" name="key" placeholder="e.g. nav.email_accounts">
        <div class="cp-ext__hint">Allowed: letters, numbers, dot, underscore, dash</div>
      </div>
    </div>

    <div class="cp-ext__form-row">
      <label class="cp-ext__label">Value</label>
      <input class="cp-ext__input" type="text" name="value" placeholder="Text shown to user">
    </div>

    <div class="cp-ext__actions">
      <button class="cp-ext__btn-primary" type="submit">Save Translation</button>
    </div>
  </form>
</div>

<div class="cp-ext__card cp-ext__card--pad">
  <div class="cp-ext__card-title" style="padding:0 0 10px 0;">Translations (max 200)</div>

  <div class="cp-ext__table-wrap">
    <table class="cp-ext__table" style="min-width: 820px;">
      <thead>
        <tr>
          <th>Key</th>
          <th>Value</th>
          <th>Lang</th>
          <th>Scope</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php if (count($items) === 0): ?>
          <tr><td colspan="5" class="cp-ext__muted">No translations found.</td></tr>
        <?php endif; ?>
        <?php foreach ($items as $it): ?>
          <tr>
            <td style="font-weight:800;color:#0b1220;"><?php echo htmlspecialchars($it->key); ?></td>
            <td><?php echo htmlspecialchars((string)$it->value); ?></td>
            <td class="cp-ext__muted"><?php echo htmlspecialchars((string)$it->lang); ?></td>
            <td class="cp-ext__muted"><?php echo htmlspecialchars((string)$it->scope); ?></td>
            <td>
              <form method="post" action="<?php echo $baseUrl; ?>&page=translations" style="display:inline;">
                <input type="hidden" name="token" value="<?php echo $token; ?>">
                <input type="hidden" name="action" value="translation_delete">
                <input type="hidden" name="id" value="<?php echo (int)$it->id; ?>">
                <button class="cp-ext__btn" type="submit" onclick="return confirm('Delete this translation?')">Delete</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
