<?php
$brand = htmlspecialchars($data['brand'] ?? 'cPanel Extended');
$accent = htmlspecialchars(cpExtAdmin_setting_get('ui.accent','global','emerald'));
$baseUrl = $data['baseUrl'] ?? 'addonmodules.php?module=cp_extended_admin';
$token = $data['token'] ?? '';
?>
<div class="cp-ext__header">
  <div>
    <h1 class="cp-ext__h1">Settings</h1>
    <p class="cp-ext__muted">Global UI settings for your module (we’ll add more settings in later parts).</p>
  </div>
</div>

<form method="post" action="<?php echo $baseUrl; ?>&page=settings" class="cp-ext__card cp-ext__card--pad">
  <input type="hidden" name="token" value="<?php echo htmlspecialchars($token); ?>">
  <input type="hidden" name="action" value="save_global_ui">

  <div class="cp-ext__form-row">
    <label class="cp-ext__label">Brand Name</label>
    <input class="cp-ext__input" type="text" name="brand_name" value="<?php echo $brand; ?>" placeholder="cPanel Extended">
  </div>

  <div class="cp-ext__form-row">
    <label class="cp-ext__label">Accent</label>
    <select class="cp-ext__input" name="accent">
      <?php foreach (['emerald','blue','indigo','rose','amber'] as $opt): ?>
        <option value="<?php echo $opt; ?>" <?php echo $accent===$opt?'selected':''; ?>>
          <?php echo ucfirst($opt); ?>
        </option>
      <?php endforeach; ?>
    </select>
    <div class="cp-ext__hint">Used later for badges/buttons.</div>
  </div>

  <div class="cp-ext__actions">
    <button class="cp-ext__btn-primary" type="submit">Save Settings</button>
  </div>
</form>
