<?php
use WHMCS\Database\Capsule;

$baseUrl = $data['baseUrl'] ?? 'addonmodules.php?module=cp_extended_admin';
$token = htmlspecialchars($data['token'] ?? '');

$secret = (string)cpExtAdmin_setting_get('queue.worker_secret','global','');

$items = Capsule::table('mod_cp_ext_queue')
  ->orderBy('id','desc')
  ->limit(50)
  ->get();
?>
<div class="cp-ext__header">
  <div>
    <h1 class="cp-ext__h1">Task Queue</h1>
    <p class="cp-ext__muted">Manage queue tasks. Worker endpoint is included in this part. You can trigger it via cron or manually.</p>
  </div>
</div>

<div class="cp-ext__grid" style="grid-template-columns: repeat(2, minmax(0,1fr));">
  <div class="cp-ext__card cp-ext__card--pad">
    <div class="cp-ext__card-title" style="padding:0 0 10px 0;">Actions</div>

    <form method="post" action="<?php echo $baseUrl; ?>&page=queue" style="margin-bottom:10px;">
      <input type="hidden" name="token" value="<?php echo $token; ?>">
      <input type="hidden" name="action" value="queue_enqueue_test">
      <button class="cp-ext__btn-primary" type="submit">Enqueue Test Task</button>
    </form>

    <div class="cp-ext__muted">
      <div style="font-weight:800;color:#0b1220;margin-bottom:6px;">Worker Secret</div>
      <div style="font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, monospace; font-size: 12px; background:#f8fafc; border:1px solid #e5e7eb; padding:10px; border-radius:12px; overflow:auto;">
        <?php echo htmlspecialchars($secret ?: 'Not set'); ?>
      </div>
      <div class="cp-ext__hint">Use this token when calling <code>modules/addons/cp_extended_admin/queue_worker.php</code>.</div>
    </div>
  </div>

  <div class="cp-ext__card cp-ext__card--pad">
    <div class="cp-ext__card-title" style="padding:0 0 10px 0;">Cron Example</div>
    <div class="cp-ext__muted">
      <div style="font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, monospace; font-size: 12px; background:#0b1220; color:#e5e7eb; padding:10px; border-radius:12px; overflow:auto;">
        php -q /path/to/whmcs/modules/addons/cp_extended_admin/queue_worker.php token=<?php echo htmlspecialchars($secret); ?> limit=10
      </div>
      <div class="cp-ext__hint">Run every 1–5 minutes depending on load.</div>
    </div>
  </div>
</div>

<div style="height:14px;"></div>

<div class="cp-ext__card cp-ext__card--pad">
  <div class="cp-ext__card-title" style="padding:0 0 10px 0;">Latest Tasks (50)</div>

  <div class="cp-ext__table-wrap">
    <table class="cp-ext__table">
      <thead>
        <tr>
          <th>ID</th>
          <th>Type</th>
          <th>Status</th>
          <th>Attempts</th>
          <th>Available</th>
          <th>Created</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php if (count($items) === 0): ?>
          <tr><td colspan="7" class="cp-ext__muted">No tasks yet.</td></tr>
        <?php endif; ?>
        <?php foreach ($items as $it): ?>
          <tr>
            <td><?php echo (int)$it->id; ?></td>
            <td><?php echo htmlspecialchars($it->type); ?></td>
            <td><span class="cp-ext__pill"><?php echo htmlspecialchars($it->status); ?></span></td>
            <td><?php echo (int)$it->attempts; ?></td>
            <td class="cp-ext__muted"><?php echo htmlspecialchars((string)($it->available_at ?: '-')); ?></td>
            <td class="cp-ext__muted"><?php echo htmlspecialchars((string)$it->created_at); ?></td>
            <td>
              <?php if (in_array((string)$it->status, ['failed','cancelled'], true)): ?>
                <form method="post" action="<?php echo $baseUrl; ?>&page=queue" style="display:inline;">
                  <input type="hidden" name="token" value="<?php echo $token; ?>">
                  <input type="hidden" name="action" value="queue_retry">
                  <input type="hidden" name="id" value="<?php echo (int)$it->id; ?>">
                  <button class="cp-ext__btn" type="submit">Retry</button>
                </form>
              <?php endif; ?>

              <?php if (in_array((string)$it->status, ['pending','running','failed'], true)): ?>
                <form method="post" action="<?php echo $baseUrl; ?>&page=queue" style="display:inline;">
                  <input type="hidden" name="token" value="<?php echo $token; ?>">
                  <input type="hidden" name="action" value="queue_cancel">
                  <input type="hidden" name="id" value="<?php echo (int)$it->id; ?>">
                  <button class="cp-ext__btn" type="submit">Cancel</button>
                </form>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
