<?php
use WHMCS\Database\Capsule;

$baseUrl = $data['baseUrl'] ?? 'addonmodules.php?module=cp_extended_admin';
$pid = isset($_GET['pid']) ? (int)$_GET['pid'] : 0;

function cpExtAdmin_product_scope(int $pid): string {
    return 'product:' . $pid;
}

function cpExtAdmin_feature_catalog(): array {
    return [
        'addon_domains' => 'Addon Domains',
        'domain_aliases' => 'Domain Aliases',
        'domain_redirects' => 'Domain Redirects',
        'dns_zone' => 'DNS Zone Editor',
        'mx_entries' => 'MX Entries',
        'email_accounts' => 'Email Accounts',
        'email_forwarders' => 'Email Forwarders',
        'autoresponders' => 'Autoresponders',
        'mailing_lists' => 'Mailing Lists',
        'email_deliverability' => 'Email Deliverability',
        'ftp_accounts' => 'FTP Accounts',
        'file_manager' => 'File Manager',
        'disk_usage' => 'Disk Usage',
        'cron_jobs' => 'Cron Jobs',
        'mysql_databases' => 'MySQL Databases',
        'postgres_databases' => 'PostgreSQL Databases',
        'remote_mysql' => 'Remote MySQL',
        'ssl_tls' => 'SSL/TLS Management',
        'backups' => 'Backups (Manual/Auto)',
        'metrics' => 'Metrics (Visitors/Stats)',
        'modsecurity' => 'ModSecurity',
        'ip_blocker' => 'IP Blocker',
        'git' => 'Git Version Control',
        'ssh' => 'SSH Access',
        'user_manager' => 'User Manager',
        'jetbackup' => 'JetBackup',
        'php_version' => 'PHP Version Switcher',
        'unban_ip' => 'Unban IP Addresses',
        'wp_toolkit' => 'WP Toolkit',
        'wordpress_manager' => 'WordPress Manager (separate module)',
    ];
}

// fetch products
$products = Capsule::table('tblproducts')
    ->select('id','name','gid','servertype','paytype','hidden')
    ->orderBy('gid','asc')
    ->orderBy('name','asc')
    ->get();

// fetch servers
$servers = Capsule::table('tblservers')
    ->select('id','name','hostname','ipaddress','active','type')
    ->orderBy('name','asc')
    ->get();

?>
<div class="cp-ext__header">
  <div>
    <h1 class="cp-ext__h1">Products & Servers</h1>
    <p class="cp-ext__muted">Enable cPanel Extended per product, choose a template, installer, and which client-area tools will be available.</p>
  </div>
</div>

<div class="cp-ext__grid" style="grid-template-columns: repeat(2, minmax(0, 1fr));">
  <div class="cp-ext__card cp-ext__card--pad">
    <div class="cp-ext__card-title" style="padding:0 0 10px 0;">Products</div>
    <div class="cp-ext__table-wrap">
      <table class="cp-ext__table" style="min-width: 0;">
        <thead>
          <tr>
            <th>Name</th>
            <th>Type</th>
            <th>Enabled</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($products as $p): 
            $scope = cpExtAdmin_product_scope((int)$p->id);
            $enabled = cpExtAdmin_setting_get('enabled', $scope, '0') === '1';
          ?>
            <tr>
              <td>
                <div style="font-weight:800;color:#0b1220;"><?php echo htmlspecialchars($p->name); ?></div>
                <div class="cp-ext__muted">Product ID: <?php echo (int)$p->id; ?> • Group: <?php echo (int)$p->gid; ?></div>
              </td>
              <td><?php echo htmlspecialchars((string)$p->servertype ?: '-'); ?></td>
              <td><?php echo $enabled ? '<span class="cp-ext__pill">On</span>' : '<span class="cp-ext__pill">Off</span>'; ?></td>
              <td><a class="cp-ext__btn" href="<?php echo $baseUrl; ?>&page=products&pid=<?php echo (int)$p->id; ?>">Configure</a></td>
            </tr>
          <?php endforeach; ?>
          <?php if (count($products) === 0): ?>
            <tr><td colspan="4" class="cp-ext__muted">No products found.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <div class="cp-ext__card cp-ext__card--pad">
    <div class="cp-ext__card-title" style="padding:0 0 10px 0;">Servers</div>
    <div class="cp-ext__table-wrap">
      <table class="cp-ext__table" style="min-width: 0;">
        <thead>
          <tr>
            <th>Name</th>
            <th>Host</th>
            <th>Type</th>
            <th>Active</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($servers as $s): ?>
            <tr>
              <td style="font-weight:800;color:#0b1220;"><?php echo htmlspecialchars($s->name); ?></td>
              <td>
                <div><?php echo htmlspecialchars((string)($s->hostname ?: $s->ipaddress ?: '-')); ?></div>
                <div class="cp-ext__muted">Server ID: <?php echo (int)$s->id; ?></div>
              </td>
              <td><?php echo htmlspecialchars((string)$s->type); ?></td>
              <td><?php echo ((string)$s->active === '1') ? '<span class="cp-ext__pill">Yes</span>' : '<span class="cp-ext__pill">No</span>'; ?></td>
            </tr>
          <?php endforeach; ?>
          <?php if (count($servers) === 0): ?>
            <tr><td colspan="4" class="cp-ext__muted">No servers found.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php if ($pid > 0):
  $prod = Capsule::table('tblproducts')->where('id',$pid)->first();
  if ($prod):
    $scope = cpExtAdmin_product_scope($pid);
    $enabled = cpExtAdmin_setting_get('enabled', $scope, '0') === '1';
    $template = cpExtAdmin_setting_get('template', $scope, 'default');
    $installer = cpExtAdmin_setting_get('installer', $scope, 'none');
    $features_json = cpExtAdmin_setting_get('features_json', $scope, '[]');
    $selected = json_decode((string)$features_json, true);
    if (!is_array($selected)) $selected = [];
    $catalog = cpExtAdmin_feature_catalog();
?>
  <div style="height:14px;"></div>
  <div class="cp-ext__card cp-ext__card--pad">
    <div class="cp-ext__header" style="margin-bottom: 8px;">
      <div>
        <h2 class="cp-ext__h1" style="font-size: 18px;">Configure Product: <?php echo htmlspecialchars($prod->name); ?></h2>
        <p class="cp-ext__muted">Enable/disable features for this product. (Client UI will use this in later parts.)</p>
      </div>
      <a class="cp-ext__btn" href="<?php echo $baseUrl; ?>&page=products">Close</a>
    </div>

    <form method="post" action="<?php echo $baseUrl; ?>&page=products&pid=<?php echo (int)$pid; ?>">
      <input type="hidden" name="token" value="<?php echo htmlspecialchars($data['token'] ?? ''); ?>">
      <input type="hidden" name="action" value="save_product_config">
      <input type="hidden" name="pid" value="<?php echo (int)$pid; ?>">

      <div class="cp-ext__grid" style="grid-template-columns: repeat(3, minmax(0,1fr));">
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Enable Extended Panel</label>
          <label style="display:flex;align-items:center;gap:10px;font-weight:700;">
            <input type="checkbox" name="enabled" value="1" <?php echo $enabled?'checked':''; ?>>
            Enabled
          </label>
          <div class="cp-ext__hint">If off, client area will show standard WHMCS module UI.</div>
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Client Template</label>
          <select class="cp-ext__input" name="template">
            <?php foreach (['default','modern','compact'] as $opt): ?>
              <option value="<?php echo $opt; ?>" <?php echo ((string)$template===$opt)?'selected':''; ?>><?php echo ucfirst($opt); ?></option>
            <?php endforeach; ?>
          </select>
          <div class="cp-ext__hint">Templates will be added in Part 7/8.</div>
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Application Installer</label>
          <select class="cp-ext__input" name="installer">
            <?php foreach (['none'=>'None','softaculous'=>'Softaculous','installatron'=>'Installatron'] as $val=>$label): ?>
              <option value="<?php echo $val; ?>" <?php echo ((string)$installer===(string)$val)?'selected':''; ?>><?php echo $label; ?></option>
            <?php endforeach; ?>
          </select>
          <div class="cp-ext__hint">Installer integration comes in Part 4.</div>
        </div>
      </div>

      <div class="cp-ext__hr" style="margin: 14px 0;"></div>

      <div class="cp-ext__card-title" style="padding:0 0 10px 0;">Client Area Features</div>
      <div class="cp-ext__grid" style="grid-template-columns: repeat(3, minmax(0,1fr));">
        <?php foreach ($catalog as $key=>$label): ?>
          <label class="cp-ext__card cp-ext__card--pad" style="box-shadow:none;">
            <div style="display:flex;align-items:flex-start;gap:10px;">
              <input type="checkbox" name="features[]" value="<?php echo htmlspecialchars($key); ?>" <?php echo in_array($key,$selected,true)?'checked':''; ?>>
              <div>
                <div style="font-weight:800;color:#0b1220;"><?php echo htmlspecialchars($label); ?></div>
                <div class="cp-ext__muted"><?php echo htmlspecialchars($key); ?></div>
              </div>
            </div>
          </label>
        <?php endforeach; ?>
      </div>

      <div class="cp-ext__actions" style="margin-top: 14px;">
        <button class="cp-ext__btn-primary" type="submit">Save Product Config</button>
      </div>
    </form>
  </div>
<?php endif; endif; ?>
