<?php
use WHMCS\Database\Capsule;

$items = Capsule::table('mod_cp_ext_logs')
  ->orderBy('id','desc')
  ->limit(50)
  ->get();
?>
<div class="cp-ext__header">
  <div>
    <h1 class="cp-ext__h1">Audit Logs</h1>
    <p class="cp-ext__muted">Shows latest 50 log entries.</p>
  </div>
</div>

<div class="cp-ext__card cp-ext__card--pad">
  <div class="cp-ext__table-wrap">
    <table class="cp-ext__table">
      <thead>
        <tr>
          <th>ID</th>
          <th>Level</th>
          <th>Message</th>
          <th>Time</th>
        </tr>
      </thead>
      <tbody>
        <?php if (count($items) === 0): ?>
          <tr><td colspan="4" class="cp-ext__muted">No logs yet.</td></tr>
        <?php endif; ?>
        <?php foreach ($items as $it): ?>
          <tr>
            <td><?php echo (int)$it->id; ?></td>
            <td><span class="cp-ext__pill"><?php echo htmlspecialchars($it->level); ?></span></td>
            <td><?php echo htmlspecialchars($it->message); ?></td>
            <td><?php echo htmlspecialchars((string)$it->created_at); ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
