<?php
// Admin layout wrapper. Expects $data and $templateFile.
if (!isset($data)) $data = [];
$brand = htmlspecialchars($data['brand'] ?? 'cPanel Extended');
$baseUrl = $data['baseUrl'] ?? 'addonmodules.php?module=cp_extended_admin';
$page = $data['page'] ?? 'dashboard';
$token = $data['token'] ?? '';
$flash = $data['flash'] ?? '';
?>
<link rel="stylesheet" href="../modules/addons/cp_extended_admin/assets/app.css?v=1.0.0">

<div id="cp-ext-admin" class="cp-ext min-h-screen">
  <div class="cp-ext__topbar">
    <div class="cp-ext__topbar-inner">
      <div class="cp-ext__brand">
        <span class="cp-ext__logo"></span>
        <span class="cp-ext__brand-text"><?php echo $brand; ?></span>
        <span class="cp-ext__badge">Admin</span>
      </div>

      <div class="cp-ext__top-actions">
        <a class="cp-ext__link" href="<?php echo $baseUrl; ?>&page=logs">Logs</a>
        <a class="cp-ext__link" href="<?php echo $baseUrl; ?>&page=queue">Queue</a>
        <a class="cp-ext__btn" href="<?php echo $baseUrl; ?>&page=settings">Settings</a>
      </div>
    </div>
  </div>

  <div class="cp-ext__container">
    <aside class="cp-ext__sidebar">
      <a class="cp-ext__nav <?php echo $page==='dashboard'?'is-active':''; ?>" href="<?php echo $baseUrl; ?>&page=dashboard">Dashboard</a>
      <a class="cp-ext__nav <?php echo $page==='products'?'is-active':''; ?>" href="<?php echo $baseUrl; ?>&page=products">Products</a>
      <a class="cp-ext__nav <?php echo $page==='cloudlinux'?'is-active':''; ?>" href="<?php echo $baseUrl; ?>&page=cloudlinux">CloudLinux</a>
      <a class="cp-ext__nav <?php echo $page==='installers'?'is-active':''; ?>" href="<?php echo $baseUrl; ?>&page=installers">Installers</a>
      <a class="cp-ext__nav <?php echo $page==='translations'?'is-active':''; ?>" href="<?php echo $baseUrl; ?>&page=translations">Translations</a>
      <div class="cp-ext__hr"></div>
      <a class="cp-ext__nav <?php echo $page==='queue'?'is-active':''; ?>" href="<?php echo $baseUrl; ?>&page=queue">Task Queue</a>
      <a class="cp-ext__nav <?php echo $page==='logs'?'is-active':''; ?>" href="<?php echo $baseUrl; ?>&page=logs">Audit Logs</a>
    </aside>

    <main class="cp-ext__main">
      <?php if ($flash): ?>
        <div class="cp-ext__alert"><?php echo htmlspecialchars($flash); ?></div>
      <?php endif; ?>

      <?php include $templateFile; ?>
    </main>
  </div>
</div>
