<?php
use WHMCS\Database\Capsule;

$baseUrl = $data['baseUrl'] ?? 'addonmodules.php?module=cp_extended_admin';
$pid = isset($_GET['pid']) ? (int)$_GET['pid'] : 0;

$products = Capsule::table('tblproducts')
    ->select('id','name','gid','servertype')
    ->orderBy('gid','asc')
    ->orderBy('name','asc')
    ->get();

function cpExtAdmin_get_installer_cfg(int $pid): array {
    $scope = 'product:' . $pid;
    $json = cpExtAdmin_setting_get('installer_config_json', $scope, '{}');
    $cfg = json_decode((string)$json, true);
    if (!is_array($cfg)) $cfg = [];
    $defaults = [
        'installer' => cpExtAdmin_setting_get('installer', $scope, 'none'),
        'softaculous' => ['api_url'=>'','api_key'=>'','api_user'=>''],
        'installatron' => ['api_url'=>'','api_key'=>''],
        'auto_install' => [
            'enabled'=>0,
            'source'=>'admin_default',
            'default_app'=>'',
            'allow_custom_fields'=>0,
            'options'=>[],
        ],
    ];
    // merge recursively shallow
    $out = array_merge($defaults, $cfg);
    $out['softaculous'] = array_merge($defaults['softaculous'], $cfg['softaculous'] ?? []);
    $out['installatron'] = array_merge($defaults['installatron'], $cfg['installatron'] ?? []);
    $out['auto_install'] = array_merge($defaults['auto_install'], $cfg['auto_install'] ?? []);
    if (!is_array($out['auto_install']['options'] ?? null)) $out['auto_install']['options'] = [];
    return $out;
}

?>
<div class="cp-ext__header">
  <div>
    <h1 class="cp-ext__h1">Installers & Auto-Install</h1>
    <p class="cp-ext__muted">Configure Softaculous/Installatron integration per product and define auto-install rules for new accounts (ordering flow). Actual API actions will be wired in Part 8 (server module).</p>
  </div>
</div>

<div class="cp-ext__card cp-ext__card--pad">
  <div class="cp-ext__table-wrap">
    <table class="cp-ext__table" style="min-width:0;">
      <thead>
        <tr>
          <th>Product</th>
          <th>Server Type</th>
          <th>Installer</th>
          <th>Auto-Install</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($products as $p):
          $cfg = cpExtAdmin_get_installer_cfg((int)$p->id);
          $inst = (string)($cfg['installer'] ?? 'none');
          $ai = (int)($cfg['auto_install']['enabled'] ?? 0) === 1;
        ?>
          <tr>
            <td>
              <div style="font-weight:800;color:#0b1220;"><?php echo htmlspecialchars($p->name); ?></div>
              <div class="cp-ext__muted">ID: <?php echo (int)$p->id; ?> • Group: <?php echo (int)$p->gid; ?></div>
            </td>
            <td><?php echo htmlspecialchars((string)$p->servertype ?: '-'); ?></td>
            <td><span class="cp-ext__pill"><?php echo htmlspecialchars($inst); ?></span></td>
            <td><?php echo $ai ? '<span class="cp-ext__pill">On</span>' : '<span class="cp-ext__pill">Off</span>'; ?></td>
            <td><a class="cp-ext__btn" href="<?php echo $baseUrl; ?>&page=installers&pid=<?php echo (int)$p->id; ?>">Configure</a></td>
          </tr>
        <?php endforeach; ?>
        <?php if (count($products) === 0): ?>
          <tr><td colspan="5" class="cp-ext__muted">No products found.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php if ($pid > 0):
  $prod = Capsule::table('tblproducts')->where('id',$pid)->first();
  if ($prod):
    $cfg = cpExtAdmin_get_installer_cfg($pid);
    $inst = (string)($cfg['installer'] ?? 'none');
    $ai = $cfg['auto_install'] ?? [];
    $opts = $ai['options'] ?? [];
?>
  <div style="height:14px;"></div>
  <div class="cp-ext__card cp-ext__card--pad">
    <div class="cp-ext__header" style="margin-bottom: 8px;">
      <div>
        <h2 class="cp-ext__h1" style="font-size: 18px;">Configure Installer: <?php echo htmlspecialchars($prod->name); ?></h2>
        <p class="cp-ext__muted">Store credentials safely. In Part 8 we’ll encrypt secrets at rest.</p>
      </div>
      <a class="cp-ext__btn" href="<?php echo $baseUrl; ?>&page=installers">Close</a>
    </div>

    <form method="post" action="<?php echo $baseUrl; ?>&page=installers&pid=<?php echo (int)$pid; ?>">
      <input type="hidden" name="token" value="<?php echo htmlspecialchars($data['token'] ?? ''); ?>">
      <input type="hidden" name="action" value="save_installer_config">
      <input type="hidden" name="pid" value="<?php echo (int)$pid; ?>">

      <div class="cp-ext__grid" style="grid-template-columns: repeat(3, minmax(0,1fr));">
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Installer</label>
          <select class="cp-ext__input" name="installer">
            <?php foreach (['none'=>'None','softaculous'=>'Softaculous','installatron'=>'Installatron'] as $val=>$label): ?>
              <option value="<?php echo $val; ?>" <?php echo ($inst===$val)?'selected':''; ?>><?php echo $label; ?></option>
            <?php endforeach; ?>
          </select>
          <div class="cp-ext__hint">Choose which installer UI will show in client area.</div>
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Auto-Install on Provisioning</label>
          <label style="display:flex;align-items:center;gap:10px;font-weight:700;">
            <input type="checkbox" name="ai_enabled" value="1" <?php echo ((int)($ai['enabled'] ?? 0)===1)?'checked':''; ?>>
            Enabled
          </label>
          <div class="cp-ext__hint">Runs after account creation (server module will execute).</div>
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Auto-Install Source</label>
          <select class="cp-ext__input" name="ai_source">
            <?php foreach (['admin_default'=>'Admin default app','client_choice'=>'Client chooses during order'] as $val=>$label): ?>
              <option value="<?php echo $val; ?>" <?php echo (((string)($ai['source'] ?? 'admin_default'))===$val)?'selected':''; ?>><?php echo $label; ?></option>
            <?php endforeach; ?>
          </select>
          <div class="cp-ext__hint">Client-choice needs configurable product custom fields (Part 8).</div>
        </div>
      </div>

      <div class="cp-ext__grid" style="grid-template-columns: repeat(3, minmax(0,1fr));">
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Default App Slug</label>
          <input class="cp-ext__input" type="text" name="ai_default_app" value="<?php echo htmlspecialchars((string)($ai['default_app'] ?? '')); ?>" placeholder="e.g. wordpress">
          <div class="cp-ext__hint">Softaculous/Installatron application identifier.</div>
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Allow Custom Settings</label>
          <label style="display:flex;align-items:center;gap:10px;font-weight:700;">
            <input type="checkbox" name="ai_allow_custom" value="1" <?php echo ((int)($ai['allow_custom_fields'] ?? 0)===1)?'checked':''; ?>>
            Enabled
          </label>
          <div class="cp-ext__hint">Lets client set admin user, site title, etc. via custom fields.</div>
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Reserved</label>
          <div class="cp-ext__muted">We’ll add app templates & validations later.</div>
        </div>
      </div>

      <div class="cp-ext__hr" style="margin: 14px 0;"></div>

      <div class="cp-ext__card-title" style="padding:0 0 10px 0;">Softaculous API (optional)</div>
      <div class="cp-ext__grid" style="grid-template-columns: repeat(3, minmax(0,1fr));">
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">API URL</label>
          <input class="cp-ext__input" type="text" name="soft_api_url" value="<?php echo htmlspecialchars((string)($cfg['softaculous']['api_url'] ?? '')); ?>" placeholder="https://server:2087/...">
        </div>
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">API User</label>
          <input class="cp-ext__input" type="text" name="soft_api_user" value="<?php echo htmlspecialchars((string)($cfg['softaculous']['api_user'] ?? '')); ?>" placeholder="root/reseller">
        </div>
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">API Key</label>
          <input class="cp-ext__input" type="password" name="soft_api_key" value="" placeholder="••••••••">
          <div class="cp-ext__hint">Current: <?php echo htmlspecialchars(cpExtAdmin_mask(cpExtAdmin_decrypt((string)($cfg['softaculous']['api_key'] ?? '')))); ?></div>
        </div>
      </div>

      <div class="cp-ext__card-title" style="padding:0 0 10px 0;margin-top:10px;">Installatron API (optional)</div>
      <div class="cp-ext__grid" style="grid-template-columns: repeat(3, minmax(0,1fr));">
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">API URL</label>
          <input class="cp-ext__input" type="text" name="inst_api_url" value="<?php echo htmlspecialchars((string)($cfg['installatron']['api_url'] ?? '')); ?>" placeholder="https://server:2083/...">
        </div>
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">API Key</label>
          <input class="cp-ext__input" type="password" name="inst_api_key" value="" placeholder="••••••••">
          <div class="cp-ext__hint">Current: <?php echo htmlspecialchars(cpExtAdmin_mask(cpExtAdmin_decrypt((string)($cfg['installatron']['api_key'] ?? '')))); ?></div>
        </div>
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Reserved</label>
          <div class="cp-ext__muted">We’ll add additional auth modes later.</div>
        </div>
      </div>

      <div class="cp-ext__hr" style="margin: 14px 0;"></div>

      <div class="cp-ext__card-title" style="padding:0 0 10px 0;">Auto-Install Options (key/value)</div>
      <div class="cp-ext__muted" style="margin-bottom:8px;">Example: <code>site_title</code>, <code>admin_user</code>, <code>admin_pass</code>, <code>admin_email</code>, <code>language</code>. We will map these per installer later.</div>

      <?php
        // render up to 6 rows
        $rows = [];
        foreach ($opts as $k=>$v) $rows[] = ['k'=>$k,'v'=>$v];
        while (count($rows) < 6) $rows[] = ['k'=>'','v'=>''];
      ?>
      <div class="cp-ext__grid" style="grid-template-columns: repeat(2, minmax(0,1fr));">
        <?php foreach ($rows as $i=>$r): ?>
          <div class="cp-ext__card cp-ext__card--pad" style="box-shadow:none;">
            <div class="cp-ext__grid" style="grid-template-columns: 1fr 1fr; gap: 10px;">
              <div class="cp-ext__form-row" style="margin:0;">
                <label class="cp-ext__label">Key</label>
                <input class="cp-ext__input" type="text" name="ai_opts[<?php echo $i; ?>][k]" value="<?php echo htmlspecialchars($r['k']); ?>">
              </div>
              <div class="cp-ext__form-row" style="margin:0;">
                <label class="cp-ext__label">Value</label>
                <input class="cp-ext__input" type="text" name="ai_opts[<?php echo $i; ?>][v]" value="<?php echo htmlspecialchars($r['v']); ?>">
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>

      <div class="cp-ext__actions" style="margin-top: 14px;">
        <button class="cp-ext__btn-primary" type="submit">Save Installer Config</button>
      </div>
    </form>
  </div>
<?php endif; endif; ?>
