<?php
use WHMCS\Database\Capsule;

$counts = [
  'settings' => Capsule::table('mod_cp_ext_settings')->count(),
  'queue_pending' => Capsule::table('mod_cp_ext_queue')->where('status','pending')->count(),
  'queue_failed' => Capsule::table('mod_cp_ext_queue')->where('status','failed')->count(),
  'logs' => Capsule::table('mod_cp_ext_logs')->count(),
];

?>
<div class="cp-ext__header">
  <div>
    <h1 class="cp-ext__h1">Dashboard</h1>
    <p class="cp-ext__muted">Foundation is installed. Next parts will add full product mapping, CloudLinux rules, installers, translations, and queue worker.</p>
  </div>
</div>

<div class="cp-ext__grid">
  <div class="cp-ext__card">
    <div class="cp-ext__card-title">Settings</div>
    <div class="cp-ext__kpi"><?php echo (int)$counts['settings']; ?></div>
    <div class="cp-ext__muted">Stored config entries</div>
  </div>

  <div class="cp-ext__card">
    <div class="cp-ext__card-title">Queue Pending</div>
    <div class="cp-ext__kpi"><?php echo (int)$counts['queue_pending']; ?></div>
    <div class="cp-ext__muted">Tasks waiting</div>
  </div>

  <div class="cp-ext__card">
    <div class="cp-ext__card-title">Queue Failed</div>
    <div class="cp-ext__kpi"><?php echo (int)$counts['queue_failed']; ?></div>
    <div class="cp-ext__muted">Tasks need retry</div>
  </div>

  <div class="cp-ext__card">
    <div class="cp-ext__card-title">Audit Logs</div>
    <div class="cp-ext__kpi"><?php echo (int)$counts['logs']; ?></div>
    <div class="cp-ext__muted">Events recorded</div>
  </div>
</div>
