<?php
use WHMCS\Database\Capsule;

$baseUrl = $data['baseUrl'] ?? 'addonmodules.php?module=cp_extended_admin';
$pid = isset($_GET['pid']) ? (int)$_GET['pid'] : 0;

$products = Capsule::table('tblproducts')
    ->select('id','name','gid','servertype')
    ->orderBy('gid','asc')
    ->orderBy('name','asc')
    ->get();

function cpExtAdmin_get_policy(int $pid): array {
    $scope = 'product:' . $pid;
    $json = cpExtAdmin_setting_get('cloudlinux_policy_json', $scope, '{}');
    $policy = json_decode((string)$json, true);
    if (!is_array($policy)) $policy = [];
    // defaults
    $defaults = [
        'enabled' => 0,
        'php_version' => 'inherit',
        'ops' => 0,
        'cpu_percent' => 0,
        'cpu_cores' => 0,
        'io' => 0,
        'iops' => 0,
        'nproc' => 0,
        'pmem_mb' => 0,
        'vmem_mb' => 0,
        'ep' => 0,
        'entry_procs' => 0,
        'inode_limit' => 0,
        'notes' => '',
    ];
    return array_merge($defaults, $policy);
}
?>
<div class="cp-ext__header">
  <div>
    <h1 class="cp-ext__h1">CloudLinux Policies</h1>
    <p class="cp-ext__muted">Define resource limits per product. In later parts, these settings will be applied during provisioning (server module) and synced on package change.</p>
  </div>
</div>

<div class="cp-ext__card cp-ext__card--pad">
  <div class="cp-ext__table-wrap">
    <table class="cp-ext__table" style="min-width:0;">
      <thead>
        <tr>
          <th>Product</th>
          <th>Server Type</th>
          <th>Policy</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($products as $p):
          $pol = cpExtAdmin_get_policy((int)$p->id);
          $on = ((int)$pol['enabled'] === 1);
        ?>
          <tr>
            <td>
              <div style="font-weight:800;color:#0b1220;"><?php echo htmlspecialchars($p->name); ?></div>
              <div class="cp-ext__muted">ID: <?php echo (int)$p->id; ?> • Group: <?php echo (int)$p->gid; ?></div>
            </td>
            <td><?php echo htmlspecialchars((string)$p->servertype ?: '-'); ?></td>
            <td><?php echo $on ? '<span class="cp-ext__pill">Enabled</span>' : '<span class="cp-ext__pill">Disabled</span>'; ?></td>
            <td><a class="cp-ext__btn" href="<?php echo $baseUrl; ?>&page=cloudlinux&pid=<?php echo (int)$p->id; ?>">Edit</a></td>
          </tr>
        <?php endforeach; ?>
        <?php if (count($products) === 0): ?>
          <tr><td colspan="4" class="cp-ext__muted">No products found.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php if ($pid > 0):
  $prod = Capsule::table('tblproducts')->where('id',$pid)->first();
  if ($prod):
    $pol = cpExtAdmin_get_policy($pid);
?>
  <div style="height:14px;"></div>
  <div class="cp-ext__card cp-ext__card--pad">
    <div class="cp-ext__header" style="margin-bottom: 8px;">
      <div>
        <h2 class="cp-ext__h1" style="font-size: 18px;">Edit Policy: <?php echo htmlspecialchars($prod->name); ?></h2>
        <p class="cp-ext__muted">Set values to <b>0</b> to mean “not set / inherit / unlimited” (we’ll interpret per server later).</p>
      </div>
      <a class="cp-ext__btn" href="<?php echo $baseUrl; ?>&page=cloudlinux">Close</a>
    </div>

    <form method="post" action="<?php echo $baseUrl; ?>&page=cloudlinux&pid=<?php echo (int)$pid; ?>">
      <input type="hidden" name="token" value="<?php echo htmlspecialchars($data['token'] ?? ''); ?>">
      <input type="hidden" name="action" value="save_cloudlinux_policy">
      <input type="hidden" name="pid" value="<?php echo (int)$pid; ?>">

      <div class="cp-ext__grid" style="grid-template-columns: repeat(3, minmax(0,1fr));">
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Enable CloudLinux policy</label>
          <label style="display:flex;align-items:center;gap:10px;font-weight:700;">
            <input type="checkbox" name="cl_enabled" value="1" <?php echo ((int)$pol['enabled']===1)?'checked':''; ?>>
            Enabled
          </label>
          <div class="cp-ext__hint">If disabled, policy is ignored.</div>
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">PHP Version</label>
          <select class="cp-ext__input" name="php_version">
            <?php foreach (['inherit'=>'Inherit','8.3'=>'PHP 8.3','8.2'=>'PHP 8.2','8.1'=>'PHP 8.1','7.4'=>'PHP 7.4'] as $val=>$label): ?>
              <option value="<?php echo $val; ?>" <?php echo ((string)$pol['php_version']===(string)$val)?'selected':''; ?>><?php echo $label; ?></option>
            <?php endforeach; ?>
          </select>
          <div class="cp-ext__hint">We’ll map this to CloudLinux selector later.</div>
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Operations Per Second (OPS)</label>
          <input class="cp-ext__input" type="number" min="0" name="ops" value="<?php echo (int)$pol['ops']; ?>">
          <div class="cp-ext__hint">0 = not set.</div>
        </div>
      </div>

      <div class="cp-ext__grid" style="grid-template-columns: repeat(3, minmax(0,1fr));">
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">CPU (%)</label>
          <input class="cp-ext__input" type="number" min="0" name="cpu_percent" value="<?php echo (int)$pol['cpu_percent']; ?>">
          <div class="cp-ext__hint">Example: 100 = 1 core.</div>
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">CPU Cores (optional)</label>
          <input class="cp-ext__input" type="number" min="0" name="cpu_cores" value="<?php echo (int)$pol['cpu_cores']; ?>">
          <div class="cp-ext__hint">If your server uses core-based limits.</div>
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">NPROC</label>
          <input class="cp-ext__input" type="number" min="0" name="nproc" value="<?php echo (int)$pol['nproc']; ?>">
          <div class="cp-ext__hint">0 = not set.</div>
        </div>
      </div>

      <div class="cp-ext__grid" style="grid-template-columns: repeat(3, minmax(0,1fr));">
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">IO (KB/s)</label>
          <input class="cp-ext__input" type="number" min="0" name="io" value="<?php echo (int)$pol['io']; ?>">
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">IOPS</label>
          <input class="cp-ext__input" type="number" min="0" name="iops" value="<?php echo (int)$pol['iops']; ?>">
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">EP (Entry Processes)</label>
          <input class="cp-ext__input" type="number" min="0" name="ep" value="<?php echo (int)$pol['ep']; ?>">
          <div class="cp-ext__hint">0 = not set.</div>
        </div>
      </div>

      <div class="cp-ext__grid" style="grid-template-columns: repeat(3, minmax(0,1fr));">
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">PMEM (MB)</label>
          <input class="cp-ext__input" type="number" min="0" name="pmem_mb" value="<?php echo (int)$pol['pmem_mb']; ?>">
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">VMEM (MB)</label>
          <input class="cp-ext__input" type="number" min="0" name="vmem_mb" value="<?php echo (int)$pol['vmem_mb']; ?>">
        </div>

        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Entry Procs (alt)</label>
          <input class="cp-ext__input" type="number" min="0" name="entry_procs" value="<?php echo (int)$pol['entry_procs']; ?>">
          <div class="cp-ext__hint">Some setups use EP only; we keep both for compatibility.</div>
        </div>
      </div>

      <div class="cp-ext__grid" style="grid-template-columns: repeat(3, minmax(0,1fr));">
        <div class="cp-ext__form-row">
          <label class="cp-ext__label">Inode Limit</label>
          <input class="cp-ext__input" type="number" min="0" name="inode_limit" value="<?php echo (int)$pol['inode_limit']; ?>">
          <div class="cp-ext__hint">0 = not set.</div>
        </div>

        <div class="cp-ext__form-row" style="grid-column: span 2;">
          <label class="cp-ext__label">Notes</label>
          <input class="cp-ext__input" type="text" name="notes" value="<?php echo htmlspecialchars((string)$pol['notes']); ?>" placeholder="Optional internal notes">
        </div>
      </div>

      <div class="cp-ext__actions" style="margin-top: 14px;">
        <button class="cp-ext__btn-primary" type="submit">Save Policy</button>
      </div>
    </form>
  </div>
<?php endif; endif; ?>
